;              D1   ADM202
;    C1      1Ŀ16             15k 1k  22
;    0.1 ĴC1+   VccĿ
;                        0.1    R2  R4
;         3         2    C3     
;        ĴC1-    V+       R1\\\ 
;    C2      4Ĵ   Ĵ6             \\\ 
;    0.1 ĴC2+    V-Ŀ         ٳ 
;                                     
;         5         15              Ŀ
;        ĴC2-   GNDſ     
;            7Ĵ   Ĵ10  C4 0.1          
; Tx   >ĴOut   In Ŀ           
;            8Ĵ   Ĵ9               R3 
; Rx   >ĴIn    OutĿ        22k
;           14Ĵ   Ĵ11               SC1602BULT-EH-G
;           ĴOut   In             \       D3
;           13Ĵ   Ĵ12            \  1Ŀ
;           ĴIn    Out            ٳ ĴVcc    
;                               3    LCD
;                                          ĴVo     
;               ٳ             2       
;                     ĴGND    
;              Ĵ  315   Ĵ    
;                  D2   AT89C2051          ĿĴL +    
;               3Ŀ12    /           
;              ĴTXD   CPU P1.0   Ĵ   ĴL -    
;                2              13    \    6Ĵ    
;              ĴRXD       P1.1ĴE      
;                  Ĵ         14       5       
;                            P1.2ĴR/W    
;                                15            4       
;                            P1.3ĴRS     
;                                16          11Ĵ    
;                            P1.4ĴD4     
;                                17         12       
;              C5            P1.5ĴD5     
;                                18        13       
;              4.7           P1.6ĴD6     
;              +                 19       14       
;                          P1.7ĴD7     
;               1Ĵ     Ĵ6      
;              ĴRST       P3.2Ŀ R6-R10  15k
;                Ĵ         7  Ŀ
;             \51k          P3.3Ŀ        
;             \R5               8     \  \  \  \  \
;                          P3.4Ŀ\  \  \  \  \
;          Ĵ                  9            
;        C630p30p           P3.5ſĴ
;        C7                     11  Ĵ    
;          ڴÿ           P3.7 Ĵ        
;               4Ĵ     Ĵ20   Ĵ            
;          ĴĴXTAL1     Vcc Ĵ  Ĵ                  VD1-VD5
;                5              10                 522
;          ĴXTAL2     GND Ĵ     \/  \/  \/  \/  \/
;            Z1                      
; GND  >ٳ              S1-S20
;              C8  C9  C10         Ĵ
;              0.1 0.1 0.1                                
; +5V  >                
;                                            Ĵ
;                                                                    
;                                                          
;                                            Ĵ
;                                                                     
;                                                           
;                                            


;
;
;      Ŀ
;       祭                      ਬ砭    
;      Ĵ
;       R1, R6..R10     2-33-0.25-15 +/- 10%  6               
;      Ĵ
;       R5              2-33-0.25-51 +/- 10%  1               
;      Ĵ
;       R2, R4          2-33-0.25-1 +/- 10%   2               
;      Ĵ
;       R3              3-38-0.125-10       1               
;      Ĵ
;                                                   
;      Ĵ
;       C1..C4, C8..C10 5--0.1-90        7               
;      Ĵ
;       C5              50-6-16-5          1               
;      Ĵ
;       C6, C7          5--30-90          2               
;      Ĵ
;                                                          
;      Ĵ
;       VD1..VD5        522                  5               
;      Ĵ
;                       奬                              
;      Ĵ
;       D1              ADM202                  1 Analog Devices
;      Ĵ
;       D2              AT89C2051               1 Atmel         
;      Ĵ
;       D3              SC1602BULT-EH-G         1  (16x2)       
;      Ĵ
;                                                         
;      Ĵ
;       S1..S20         FT008                   20Bopla         
;      


;#24, Char        Put Char as data
;#25              Get LCD data
;#26              Get LCD addr
;#27, Char        Put Char as command
;01   Clear            
;02   Home             
;80   Home line 1      
;BD   Home line 2      
;14   Cursor right     
;10   Cursor left      
;18   Scrool left      
;1C   Scrool right     
;0D   Blink cursor     
;0E   Underbar cursor  
;0C   Cursor off       

        DSEG
        ORG 70h
UChars: DS 8
IChar:  DS 1

        CSEG
        ORG       0             ; Reset vector.
        JMP Start               ;

        ORG       03H           ; External interrupt 0.
        RETI

        ORG       0BH           ; Timer 0 interrupt.
        jmp T0Int

        ORG       13H           ; External interrupt 1.
        RETI

        ORG       1BH           ; Timer 1 interrupt.
        RETI

        ORG       23H           ; TI/RI interrupt.
        jmp IntRI
;--------------------------------------------------------------------------
; ACC*100us delay, assumes 12MHz clock
;--------------------------------------------------------------------------

Wait:
        push    1               ;24 save register R1

WaitLp: mov     r1, #61         ;12 50 DJNZ instr = 100us
        djnz    r1, $           ;24
        nop                     ;12
        djnz    acc, WaitLp     ;24

        pop     1               ;24 restore register R1
        ret                     ;24

;acc := 100
;r1 := 61
;Wait := (24+acc*(12+r1*24+24+12)+24+24)/15.08e6
;0.0100312997
;--------------------------------------------------------------------------
Wait_40u:
        push    1               ;24 save register R1
        mov     r1,#22          ;12 22 DJNZ instr = 40us
        djnz    r1,$            ;24
        pop     1               ;24 restore register R1
        ret                     ;24

;r1 := 22
;Wait40 := (24+12+(r1*24)+24+24)/15.08e6
;0.0000405836

;--------------------------------------------------------------------------

;--------------------------------------------------------------------------
; LCD
;--------------------------------------------------------------------------
E       BIT       P1.1
RD_WR   BIT       P1.2
RS      BIT       P1.3  ;1 - Data, 0 - Control
D4      BIT       P1.4
D5      BIT       P1.5
D6      BIT       P1.6
D7      BIT       P1.7
Light   BIT       P3.7
InitLCD:
        orl P3,#00111100b
        mov A,#150
        call Wait

        mov A,#30h
        setb C
        call PutNibble
        mov A,#41
        call Wait

        mov A,#30h
        setb C
        call PutNibble
        mov A,#1
        call Wait

        mov A,#30h
        setb C
        call PutNibble
        mov A,#41
        call Wait

        mov A,#20h
        setb C
        call PutNibble
        mov A,#41
        call Wait_40u

        mov A,#28h
        setb C
        call PutLCD

        mov A,#8h
        setb C
        call PutLCD

        mov A,#0dh
        setb C
        call PutLCD

        mov A,#06h
        setb C
        call PutLCD

        mov A,#1h
        setb C
        call PutLCD

        mov A,#17
        call Wait
        ret
;--------------------------------------------------------------------------
; Put A into LCD.
; If set Carry flag then put control byte
; else put data byte
;--------------------------------------------------------------------------
PutLCD:
        push 0
        mov r0,P3
        orl P3,#00111100b
        push ACC
        call PutNibble
        pop ACC
        swap A
        call PutNibble
        call Wait_40u           ; pause for 40us
        mov A,r0
        anl p3,#11000011b
        orl p3,A
        pop 0
        mov P1,#11111101b
        ret

PutNibble:
        anl A,#0f0h
        jc PutCtl
        orl A,#8                ; Set 'RS' if data put
PutCtl:
        mov P1,A
        setb E
        nop
        clr E
        ret
;--------------------------------------------------------------------------
; Get from LCD to A
; If set Carry flag then get control byte
; else get data byte
;--------------------------------------------------------------------------
GetLCD:
        push 0
        mov r0,P3
        orl P3,#00111100b       ; Set scan lines

        mov P1,#11111101b
        mov RS,C
        setb RD_WR

        push 1

        call GetNibble
        mov r1,A
        call GetNibble
        swap A
        orl a,r1

        mov r1,a

        call Wait_40u           ; pause for 40us
        mov A,r0
        anl p3,#11000011b
        orl p3,A
        mov a,r1
        pop 1
        pop 0
        mov P1,#11111101b
        ret

GetNibble:
        setb E
        nop
        mov A,P1
        clr E
        anl A,#0f0h
        ret
;--------------------------------------------------------------------------
; Load user char.
; A = Char index, DPTR = Char data
;--------------------------------------------------------------------------
UserChar:
        push 0
        push 1
        push 2
        rl a
        rl a
        rl a
        orl a,#40h
        mov r0,a
        clr C
        call GetLCD        ;Read current DD address
        mov r1,A
        mov a,r0
        setb C
        call PutLCD        ;Set CG RAM address to char ACC
        mov r2,#7
RowLoop:
        mov A,#0
        movc A,@A+DPTR
        clr C
        call PutLCD        ;Write row of pixels
        call Wait_40u
        call Wait_40u
        inc dptr
        djnz r2,RowLoop

        mov A,#0
        clr C
        call PutLCD        ;Write cursor row (descender)

        mov a,r1
        orl a,#80h
        setb C
        call PutLCD        ;Restore DD mode (& address)
        pop 2
        pop 1
        pop 0
        ret
;--------------------------------------------------------------------------
Chars:  db 000h, 000h, 012h, 015h, 01Dh, 015h, 012h ;  0  80
        db 001h, 00Eh, 018h, 01Eh, 011h, 011h, 00Eh ;  1  81
        db 000h, 000h, 012h, 012h, 012h, 01Fh, 001h ;  2  82
        db 000h, 000h, 006h, 00Ah, 00Ah, 01Fh, 011h ;  3  83
        db 000h, 004h, 00Eh, 015h, 00Eh, 004h, 004h ;  4  84
        db 000h, 000h, 01Fh, 010h, 010h, 010h, 010h ;  5  85
        db 000h, 000h, 011h, 013h, 015h, 019h, 011h ;  6  86
        db 000h, 004h, 011h, 013h, 015h, 019h, 011h ;  7  87
        db 000h, 000h, 011h, 012h, 014h, 01Ch, 013h ;  8  88
        db 000h, 000h, 007h, 009h, 009h, 009h, 019h ;  9  89
        db 000h, 000h, 011h, 01Bh, 015h, 011h, 011h ;  10 8a
        db 000h, 000h, 011h, 011h, 01Fh, 011h, 011h ;  11 8b
        db 000h, 000h, 01Fh, 011h, 011h, 011h, 011h ;  12 8c
        db 000h, 000h, 00Fh, 011h, 00Fh, 009h, 011h ;  13 8d
        db 000h, 000h, 01Fh, 004h, 004h, 004h, 004h ;  14 8e
        db 000h, 000h, 015h, 015h, 00Eh, 015h, 015h ;  15 8f
        db 000h, 000h, 01Ch, 012h, 01Eh, 011h, 01Eh ;  16 90
        db 000h, 000h, 010h, 010h, 01Eh, 011h, 01Eh ;  17 91
        db 000h, 000h, 011h, 011h, 01Dh, 015h, 01Dh ;  18 92
        db 000h, 000h, 00Eh, 011h, 006h, 011h, 00Eh ;  19 93
        db 000h, 000h, 015h, 015h, 015h, 015h, 01Fh ;  20 94
        db 000h, 000h, 01Eh, 001h, 00Fh, 001h, 01Eh ;  21 95
        db 000h, 000h, 015h, 015h, 015h, 01Fh, 001h ;  22 96
        db 000h, 000h, 011h, 011h, 00Fh, 001h, 001h ;  23 97
        db 000h, 000h, 018h, 008h, 00Eh, 009h, 00Eh ;  24 98
        db 012h, 015h, 015h, 01Dh, 015h, 015h, 012h ;  25 99
        db 01Fh, 010h, 010h, 01Eh, 011h, 011h, 01Eh ;  26 9a
        db 012h, 012h, 012h, 012h, 012h, 01Fh, 001h ;  27 9b
        db 006h, 00Ah, 00Ah, 00Ah, 00Ah, 01Fh, 011h ;  28 9c
        db 004h, 01Fh, 015h, 015h, 01Fh, 004h, 004h ;  29 9d
        db 01Fh, 011h, 010h, 010h, 010h, 010h, 010h ;  30 9e
        db 011h, 011h, 013h, 015h, 019h, 011h, 011h ;  31 9f
        db 015h, 011h, 013h, 015h, 019h, 011h, 011h ;  32 a0
        db 007h, 009h, 009h, 009h, 009h, 009h, 019h ;  33 a1
        db 01Fh, 011h, 011h, 011h, 011h, 011h, 011h ;  34 a2
        db 00Fh, 011h, 011h, 00Fh, 005h, 009h, 011h ;  35 a3
        db 011h, 011h, 011h, 00Ah, 004h, 008h, 010h ;  36 a4
        db 011h, 015h, 015h, 00Eh, 015h, 015h, 011h ;  37 a5
        db 010h, 010h, 010h, 01Eh, 011h, 011h, 01Eh ;  38 a6
        db 011h, 011h, 011h, 019h, 015h, 015h, 019h ;  39 a7
        db 011h, 015h, 015h, 015h, 015h, 015h, 01Fh ;  40 a8
        db 00Eh, 011h, 001h, 007h, 001h, 011h, 00Eh ;  41 a9
        db 015h, 015h, 015h, 015h, 015h, 01Fh, 001h ;  42 aa
        db 011h, 011h, 011h, 01Fh, 001h, 001h, 001h ;  43 ab
        db 018h, 008h, 008h, 00Eh, 009h, 009h, 00Eh ;  44 ac

        ;                                                   
RusLat: db 'A',9ah,'B',9eh,9ch,'E',0a5h,'3',9fh,0a0h,'K',0a1h,'M','H','O',0a2h
        ;                                                       
        db 'P','C','T',0a4h,9dh,'X',9bh,0abh,0a8h,0aah,0a6h,0a7h,'b',0a9h,99h,0a3h
        ;                                                
        db 'a',81h,90h,85h,83h,'e',8fh,93h,86h,87h,88h,89h,8ah,8bh,'o',8ch
        ;                                                
        db 'p','c',8eh,'y',84h,'x',82h,97h,94h,96h,98h,92h,91h,95h,80h,8dh

;--------------------------------------------------------------------------
; Convert char from A and put it
;--------------------------------------------------------------------------
PutChar:
        push 0
        push 1
        push 2
        cjne a,#18h,No18
        jmp PCInit
No18:
        cjne a,#0,NoInit        ; if Char = 0 then
PCInit:
        mov r0,#UChars          ;   Clear UChars and IChar
        mov r1,#8
InitLoop:
        mov @r0,#0ffh
        inc r0
        djnz r1,InitLoop
        mov IChar,#0
        jmp PCExit
NoInit:
        jbc ACC.7,ExtChar
        jmp PutCh
ExtChar:
        cjne a,#060h,No60       ;'' - ''
        jmp Eq60
No60:
        jc Less60
Eq60:
        subb a,#48
Less60:
        mov dptr,#RusLat
        movc a,@a+dptr
        jbc ACC.7,UsrChar
        jmp PutCh
UsrChar:
        mov r2,a                ; Store char
        mov r0,#UChars
        mov r1,#8
FindCharLoop:                   ; Find stored char in the UChars list
        mov a,@r0
        cjne a,2,NextChar
        clr C
        mov a,#8
        subb a,r1               ; Calculate UChar index
        jmp PutCh               ; Output user char
NextChar:
        inc r0
        djnz r1,FindCharLoop
                                ; Char not found in the UChar list
        mov a,IChar
        cjne a,#7,Not7
        jmp PutBlank
Not7:
        mov a,#UChars
        add a,IChar
        mov r0,a
        mov a,r2
        mov @r0,a               ; Store char in the UChar list
        mov b,#7
        mul ab                  ; Calculate index in chars array
        mov r1,a
        mov dptr,#Chars
        mov a,dpl
        add a,r1
        mov dpl,a
        mov a,dph
        addc a,b
        mov dph,a
        mov a,IChar
        call UserChar           ; Load char into LCD
        mov a,IChar
        inc IChar
        jmp PutCh
PutBlank:
        mov a,#'.'
PutCh:                          ; Put ASCII7 char
        clr C
        call PutLCD
PCExit:
        pop 2
        pop 1
        pop 0
        ret
;--------------------------------------------------------------------------
; Serial
;--------------------------------------------------------------------------
Send:
        mov SBUF,A
        jnb TI,$
        clr TI
        ret
;--------------------------------------------------------------------------
Receive:
        jnb RI,$                ; Wait for receive command
        mov A,SBUF
        clr RI
        ret
;--------------------------------------------------------------------------
; A = TimeOut in 10ms
; Return:
;        if C then Timeout
;        else A = SBUF
;--------------------------------------------------------------------------
ReceiveTimeOut:
        push PSW                ; 24
        setb RS0                ; 12   Bank 1
        mov  r2,A               ; 12
Loop_r2:
        mov r1,#21              ; 12
Loop_r1:
        mov r0,#150             ; 12
Loop_r0:
        jbc RI,Rcv              ; 24

        djnz r0,Loop_r0         ; 24
        djnz r1,Loop_r1         ; 24
        djnz r2,Loop_r2         ; 24
        pop PSW                 ; 24
        setb C                  ; 12
        ret                     ; 24
Rcv:
        mov A,SBUF              ; 12
        pop PSW                 ; 24
        clr C                   ; 12
        ret                     ; 24

;r2:=100
;r1:=21
;r0:=150
;Delay := (r2*(12+r1*(12+r0*(24+24)+24)+24))/15.08e6
;1.0079045093
;--------------------------------------------------------------------------
; Keyboard
;--------------------------------------------------------------------------
ScanKBD:
        mov P1,#11111101b       ; E=0
        orl P3,#00111100b
        clr P3.2
        push 2
        mov r2,#0
        push 1
        mov r1,#4
ScanLoop1:
        push 0
        mov r0,#5
        mov A,P1
        cpl A
ScanLoop2:
        rlc A
        inc r2
        jc Press
        djnz r0,ScanLoop2
        pop 0
        mov A,P3
        orl A,#00000010b
        rlc A
        anl A,#00111100b
        anl P3,#11000011b
        orl P3,A
        djnz r1,ScanLoop1
        pop 1
        pop 2
        clr A
        ret
Press:
        mov A,r2
        dec a
        mov dptr,#KbdTbl
        movc a,@a+dptr
        pop 0
        pop 1
        pop 2
        ret
;--------------------------------------------------------------------------
KbdTbl: db 'B', 'A', '9', '8', '7'
        db 'D', 'C', '6', '5', '4'
        db 'F', 'E', '3', '2', '1'
        db  13,   8, '-', '.', '0'
;--------------------------------------------------------------------------
ReadKey:
        call ScanKBD
        jz ReadKey
        push ACC
ReadKey1:
        call ScanKBD
        jnz ReadKey1
        pop ACC
        ret
;--------------------------------------------------------------------------
; Terminal
;--------------------------------------------------------------------------

;--------------------------------------------------------------------------
TermCR:
        clr C
        call GetLCD
        cjne a,#63,TNo63
        jmp Home2
TNo63:
        jc  Home2
        cjne a,#67,TNo67
        jmp Home1
TNo67:
        jc Home1
Home1:  mov a,#80h
        jmp TPut
Home2:  mov a,#0C0h
TPut:
        setb C
        call PutLCD
        ret
;--------------------------------------------------------------------------
TermBS:
        mov a,#10h
        setb C
        call PutLCD
        mov a,#' '
        clr C
        call PutLCD
        mov a,#10h
        setb C
        call PutLCD
        ret
;--------------------------------------------------------------------------
TermClear:
        mov a,#1
        setb C
        call PutLCD
        ret
;--------------------------------------------------------------------------
PutTerm:
        cjne a,#8, NoBS
        call TermBS
        ret
NoBS:
        cjne a,#13, NoCR
        call TermCR
        ret
NoCR:
        call PutChar
        ret
;--------------------------------------------------------------------------
IntRI:
        jnb RI,NoRI
        push PSW
        push ACC
        push dpl
        push dph
        mov A,SBUF
        clr RI

        cjne A,#24,No24
        mov A,#10
        call ReceiveTimeOut
        jc NoPut
        clr C
        call PutLCD
        jmp NoPut
No24:
        cjne A,#26,No26
        setb C
        call GetLCD
        call Send
        jmp NoPut
No26:
        cjne A,#25,NoGet
        clr C
        call GetLCD
        call Send
        jmp NoPut
NoGet:
        cjne A,#27,PutData
        mov A,#10
        call ReceiveTimeOut
        jc NoPut
        setb C
        jmp PutCommand
PutData:
        call PutTerm
        jmp NoPut
PutCommand:
        call PutLCD
NoPut:
        pop dph
        pop dpl
        pop ACC
        pop PSW
        call SetTimer
NoRI:
        reti
;--------------------------------------------------------------------------
;15.08e6/12
;8434 1 149  1256666
;$10000 - 8434 57102 $DF0E
x1h     equ 0DFh
x1l     equ 0eh
x2      equ 1
x3      equ 149
x4      equ 10                    ; Ligth time in seconds
;--------------------------------------------------------------------------
SetTimer:
        mov TH0,#x1h
        mov TL0,#x1l
        push acc
        push PSW
        setb RS1                ; Bank 2
        mov r1,#x2
        mov r0,#x3
        mov r2,#x4
        setb Light
        pop PSW
        pop acc
        ret
;--------------------------------------------------------------------------
T0Int:
        push acc
        mov TH0,#x1h
        mov TL0,#x1l
        push PSW
        setb RS1                ;  Bank 2
        djnz r0, T0IntL1
        mov r0,#x3
        djnz r1, T0IntL1
        mov r1,#x2
        mov r0,#x3
        djnz r2, T0IntL1
        mov r1,#x2
        mov r0,#x3
        mov r2,#x4
        clr Light
T0IntL1:
        pop PSW
        pop acc
        reti
;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
Start:
        clr EA
        mov sp,#3fh
        setb Light
        call PutChar
        call InitLCD
;--------------------------------------------------------------------------
;Serial Port
;f:=15.08e6
;Smod := 0
;Baud := 9600
;Th := -f*2^smod/(32*12*Baud)
;-4.091204

;--------------------------------------------------------------------------
        mov SCON,#050h
        mov TMOD,#021h
        mov TH0,#x1h
        mov TL0,#x1l

        mov TH1,#-4
        setb TR1
        setb TR0
        setb IE0
        mov SBUF,#00H
        clr TI
        clr RI

;        setb PS
        setb EA
        setb ES

        setb IT0
        setb ET0
        mov A,#' '
        call Send

        call SetTimer
        mov a,#0
        call PutChar
MainLoop:
        call ReadKey
        jz MainLoop
        call SetTimer
        cjne a,#'E',No_E
        mov a,#1ch              ; Scrool right
        setb C
        call PutLCD
        jmp MainLoop
No_E:
        cjne a,#'F',No_F
        mov a,#18h              ; Scrool left
        setb C
        call PutLCD
        jmp MainLoop
No_F:
        call Send
        jmp MainLoop
        end
